﻿Function Start-SetupDiag {
    $SetupDiagPath = "$env:ProgramData\WaaS\SetupDiag.exe"
    if (Test-Path -Path $SetupDiagPath)
        {
        Start-Process -FilePath $SetupDiagPath -PassThru -Wait
        }
    else
        {
        Write-Output "No Setup Diag found in $SetupDiagPath"
        }
}

try
{
    $tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
    $tsBuild = $tsenv.Value("WaaS_UpgradeBuild")
    $WaaSRegistryPath = "HKLM:\$($tsenv.Value("RegistryPath"))\$tsBuild"
    write-output "WaaS Registry Path = $WaaSRegistryPath"
}
catch
{
	Write-Verbose "Not running in a task sequence."
    $tsbuild = Get-ItemPropertyValue -Path "HKLM:\SOFTWARE\WaaS" -Name "LastOSUpgradeTo"
    $WaaSRegistryPath = "HKLM:\SOFTWARE\WaaS\$tsbuild"
}

$SetupDiagRegPath = "HKLM:\SYSTEM\Setup\setupdiag\results"
$SetupDiagRegPathMoSetup = "HKLM:\system\setup\MoSetup\Volatile\SetupDiag\"
$RegPathRollback = "HKLM:\SOFTWARE\WaaS\Rollback\$tsBuild"

if (!(Test-Path ($RegPathRollback))){$Null = New-Item -Path $RegPathRollback -ItemType Directory -Force}
remove-item -Path $RegPathRollback -Force

# Check Default SetupDiag Info First
if (Test-Path $SetupDiagRegPath)
    {
    $SetupDiag = get-item $SetupDiagRegPath
    }

#If Default Setup Diag info is Compat Info... trigger Setup Diag
if ($SetupDiag.GetValue("ProfileName") -eq "CompatScanOnly")
    {
    Start-SetupDiag
    #Using New Info for Reports
    if (Test-Path $SetupDiagRegPathMoSetup)
        {
        Copy-Item -Path $SetupDiagRegPathMoSetup -Destination $RegPathRollback
        }
    }
#If it's not... lets use it for reports
else
    {
    if (Test-Path $SetupDiagRegPath)
        {
        Copy-Item -Path $SetupDiagRegPath -Destination $RegPathRollback -Force
        }
    }


#Setup Diag info should have been copied to the Rollback Registry Location
if (Test-Path -Path $RegPathRollback)
    {
    $RegPathPSItem = get-item -Path $RegPathRollback
    $SetupElapsedTime = $RegPathPSItem.GetValue("UpgradeElapsedTime") 
    if ($SetupElapsedTime)
        {
        if ($SetupElapsedTime -match "-"){$SetupElapsedTimeTotalMinutes = 'N/A'}
        
        else{
            [int]$SetupElapsedTimeHours = $SetupElapsedTime.Split(":")[0]
            [int]$SetupElapsedTimeMinutes = $SetupElapsedTime.Split(":")[1]
            $SetupElapsedTimeTotalMinutes = $SetupElapsedTimeHours * 60 + $SetupElapsedTimeMinutes
            }
        }
    $TargetOSVersion = $RegPathPSItem.GetValue("TargetOSVersion")
    if ($TargetOSVersion){$SetupDiagBuild = ($TargetOSVersion.Split(" ")[0]).split(".")[2]}
    }
if ($RegPathPSItem)
    {
    if ($RegPathPSItem.getvalue("ProfileName") -ne "NoMatchFound" -and $RegPathPSItem.getvalue("ProfileName") -ne "CompatScanOnly")
        {
        $SetupDiagProfile = $RegPathPSItem.getvalue("ProfileName")
        $SetupDiagErrorCode = ((($RegPathPSItem.getvalue("FailureDetails").split(","))[0]).split("=")[1]).replace(" ","")
        $SetupDiagErrorExt = ((($RegPathPSItem.getvalue("FailureDetails").split(","))[1]).split("=")[1]).replace(" ","")
        $SetupDiagFullError = "$SetupDiagErrorCode-$SetupDiagErrorExt"
        if ($SetupDiagFullError)
            {
            Write-Output "Rollback IPUFailedStepReturnCode set to value $SetupDiagFullError"
            New-ItemProperty -Path $WaaSRegistryPath -Name "IPUFailedStepReturnCode" -Value $SetupDiagFullError -Force
            New-ItemProperty -Path $WaaSRegistryPath -Name "IPUReturnStatus" -Value $SetupDiagProfile -Force
            #New-ItemProperty -Path $WaaSRegistryPath -Name "IPUReturnCode" -Value $SetupDiagFullError -Force  
            if ($TSENV)
                {
                $tsenv.Value("SetupEngineFailedStepReturnCode") = $SetupDiagFullError
                }
            }
        }
        
    else
        {
        New-ItemProperty -Path $WaaSRegistryPath -Name "IPUFailedStepReturnCode" -Value "NoMatchFound" -Force
            if ($TSENV)
            {
            $tsenv.Value("SetupEngineFailedStepReturnCode") = "NoMatchFound"
            }
        }
    }